package gov.va.med.mhv.usermgmt.converter;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.usermgmt.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.usermgmt.data.model.EmergencyContact;
import gov.va.med.mhv.usermgmt.data.model.HealthCareProvider;

public class HealthCareProviderConverter extends AbstractConverter<HealthCareProviderDTO, HealthCareProvider> {

	@Override
	public HealthCareProviderDTO convertFrom(HealthCareProvider e) {
		HealthCareProviderDTO enDTO = new HealthCareProviderDTO();
		enDTO.setComments(e.getComments());
		enDTO.setEmailAddress(e.getEmailAddress());
		enDTO.setFirstName(e.getFirstName());
		enDTO.setHealthCareProviderId(e.getHealthCareProviderId());
		enDTO.setLastName(e.getLastName());
		enDTO.setOtherClinician(e.getOtherClinician());
		enDTO.setProviderType(e.getProviderType());
		enDTO.setWorkPhone(e.getWorkPhone());
		enDTO.setWorkPhoneExt(e.getWorkPhoneExt());
		enDTO.setUserProfileId(e.getUserProfileId());
		return enDTO;
	}

	@Override
	public HealthCareProvider convertTo(HealthCareProviderDTO enDto) {
		HealthCareProvider e = new HealthCareProvider();
		e.setComments(enDto.getComments());
		e.setEmailAddress(enDto.getEmailAddress());
		e.setFirstName(enDto.getFirstName());
		e.setHealthCareProviderId(enDto.getHealthCareProviderId());
		e.setLastName(enDto.getLastName());
		e.setOtherClinician(enDto.getOtherClinician());
		e.setProviderType(enDto.getProviderType());
		e.setWorkPhone(enDto.getWorkPhone());
		e.setWorkPhoneExt(enDto.getWorkPhoneExt());
		e.setUserProfileId(enDto.getUserProfileId());
		return e;
	}

}
